<?PHP
/**
* A template for any page that follows the standard inbox format in webmail (banner at the top, menu items underneath, sidebar with folders to the left of the main content).
*
* This is intended to be called using the {@link Template} library:
*
* <code>
* //generates the content for the inbox/compose view using $data, and passes it to the template as the $contents variable
* $this->template->load('template', 'inbox/compose', $data);
* </code>
*
* The header markup has been altered slightly from the original header/header markup: the menu nav has been moved out of the #header div
* into .body-main so that the main body of the page can have a form that is independent of the search form in #header, but still contains the menu controls.
*
* Known issues:
* 	- Horizontal scrolling (viewport < 1000px) looks pretty weird with the fixed sidebar & menu; at minimum, it would be good to give the sidebar a background color, but that
* 		interferes with the compose button background color in IE8.  Revisit this later. (Issue existed prior to Sprint 12).
* 	- Need to revisit min-width values overall: top nav starts collapsing before it hits its min width, inbox tables can't fit the full byte size at min width
*   -
*
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/* variables that should be passed to the template
	$CI; //instance
	$page_title; //the name of the page, used in a hidden <h2> to indicate the page name to accessibility users
	$menu_partial; //the snippet of HTML used for the controls for this page */
if(empty($form_destination)) $form_destination = current_url(); //where the primary form on this page should go to on submission
$theme_css = element('theme_css_name', $CI->user_theme);

$optional_vars = array( 'current_user' => '',
						'display_name' => '',
						'json_mailbox_list' => '{}',
						'mailboxes' => '',
						'other_members' => array(),
						'title' => '',
						'show_workflow' => false);

//make sure that optional vars all have a value
foreach( $optional_vars as $optional_var => $default_value){
	if(!isset($$optional_var)) $$optional_var = $default_value;
}

$user_feedback_message = $this->session->userdata('message');

if(!empty($_SESSION['unseen']) && $menu_partial == '_inbox_menu')
	$title .= ' ('.$_SESSION['unseen'].')';

?>

<!doctype html>
<html>
	<head>
		<title><?PHP echo $title;?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
		<link rel="icon" href="/favicon.ico" type="image/x-icon" />
		<link rel="stylesheet" type="text/css" href="/css/grids.css" />
		<link rel="stylesheet" type="text/css" href="/css/main.css" />
		<link rel="stylesheet" type="text/css" href="/css/jquery.lightbox-0.5.css" />
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui.min.css" />
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui.structure.min.css" />
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui.theme.min.css" />
		<link rel="stylesheet" type="text/css" href="/jscripts/fancybox/jquery.fancybox-1.3.4.css" media="screen" />
		<link rel="stylesheet" type="text/css" href="/css/tinyeditor.css" />
		<link rel="stylesheet" type="text/css" href="/css/token-input-dpii.css" />
		<link rel="stylesheet" href="/css/multiselect/common.css" type="text/css" />
		<link type="text/css" href="/css/multiselect/ui.multiselect.css" rel="stylesheet" />
		<link rel="stylesheet" href="/css/qtip/jquery.qtip.min.css" type="text/css" />
		<link rel="stylesheet" href="/css/qtip/jquery.qtip.css" type="text/css" />
		<link rel="stylesheet" href="/css/jquery.dropdown.css" type="text/css" />
		<link rel="stylesheet" href="/css/custom-theme/chosen.min.css" type="text/css" />
		<?PHP if(!empty($theme_css)) { echo '<link rel="stylesheet" type="text/css" href="/css/themes/' . $theme_css . '.css" />'; } ?>
		<link href="<?php echo site_url('css/bootstrap-scoped.min.css') ?>" rel="stylesheet" type="text/css" media="all" />
		<link href="<?php echo site_url('css/localized.css') ?>" rel="stylesheet" type="text/css" media="all" />
		<script type="text/javascript" src="/jscripts/jquery.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.migrate.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.lightbox-0.5.min.js"></script>
		<script type="text/javascript" src="/jscripts/fancybox/jquery.fancybox-1.3.4.js"></script>
		<script type="text/javascript" src="/jscripts/fancybox/jquery.mousewheel-3.0.4.pack.js"></script>
		<script type="text/javascript" src="/jscripts/libraryfunctions.js"></script>
		<script type="text/javascript" src="/jscripts/headerfunctions.js"></script>
		<script type="text/javascript" src="/jscripts/helper.js"></script>
		<script type="text/javascript" src="/jscripts/bootstrap-3.2.2.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery-ui.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.jeditable.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.form.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.filedrop.js"></script>
		<script type="text/javascript" src="/jscripts/tinyeditor.js"></script>
		<script type="text/javascript" src="/jscripts/ui.multiselect.js"></script>
		<script type="text/javascript" src="/jscripts/qtip/jquery.qtip.min.js"></script>
		<script type="text/javascript" src="/jscripts/qtip/jquery.qtip.js"></script>
		<script type="text/javascript" src="/jscripts/qtip/imagesloaded.pkg.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.dropdown.js"></script>
		<!-- View that displays jQuery message slideout whenever there is a user action performed. Uses jquery.noty.js library. http://needim.github.com/noty/ -->
		<script type="text/javascript" src="/jscripts/noty/jquery.noty.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/top.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/topLeft.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/topRight.js"></script>
		<script type="text/javascript" src="/jscripts/noty/layouts/inline.js"></script>
		<script type="text/javascript" src="/jscripts/noty/themes/default.js"></script>
		<script type="text/javascript" src="/jscripts/noty/themes/inline.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.tokeninput.js"></script>
		<script type="text/javascript" src="/jscripts/chosen.jquery.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.shorten.1.0.js"></script>
		<!--[if lte IE 8]><script type="text/javascript" src="/jscripts/css3-mediaqueries.js"></script><![endif]-->
		<?php if(is_on_local()): ?><!--<style> .controller-inbox.action-index, .controller-message.action-compose, .controller-message.action-viewmsg{ overflow-y: scroll; } </style>--><?php endif //uncomment CSS to see profiler output ?>
	</head>
	<body class="controller-<?php echo strip_from_end('-controller', make_string_css_friendly(get_class($CI))) ?> action-<?php echo make_string_css_friendly($CI->router->fetch_method()) ?>">
	<?php if($CI->session->userdata("is_loggedin") == "true") { echo $CI->load->view('options_bar', compact('CI', 'group_mailboxes', 'show_adminpanel_link'), TRUE); } ?>
	<div id="wrapper" class="inbox-template <?php echo make_string_css_friendly( get_class($CI).'-'.$CI->router->fetch_method() ) ?>">
		<?PHP  /*make sure csrf token is on the page for AJAX requests (GET as well as POST) */ /* is it a problem that this isn't actually in a form? */
			echo form_hidden($CI->security->get_csrf_token_name(),$CI->security->get_csrf_hash(),$CI->security->get_csrf_token_name(),'token');
		?>
		<?PHP
			if($CI->session->userdata("just_logged_in")) {
				if(isset($first_login_message)) echo $first_login_message;
				$CI->session->set_userdata("just_logged_in",FALSE);
			}
		?>
		<div id="header" class="settings">
			<?PHP echo $CI->load->view('header/banner', array(), TRUE); ?>
            <a style="display: block; top: 0; width: 100px; height: 100px; position: absolute; font-size: 0; line-height: 0; color: transparent;" title="Inbox" href="/inbox">Logo and Link to Inbox</a>
		<?php if($CI->session->userdata("is_loggedin") == "true"): ?>
          	<div id="version_container"><?php echo 'Version ' . APPLICATION_BUILD_VERSION;?></div>
			<div id="search">
				<?PHP echo form_open_multipart("inbox/search", array("id" => "search_form")); ?>
					<?PHP echo form_label("Search Input","search_input",array("class" => "hidden_context")); ?>
					<?PHP echo form_input(array("name" => "search_input","id" => "search_input", "style" => "")); ?>
                	<button class="minimal minimal-short" id="search_btn" name="search" type="submit" onClick="$(this).attr('clicked','true');">Search</button>
				<?php echo form_close(); ?>
				<a id="advance_search_button" class="minimal minimal-short" title="Advanced Search" alt="Advanced Search" href="#"><img onclick="$('#advance_search_button').click();" id="advanced_search_icon" src="/images/advanced-search-strong.png" alt="Advanced Search Icon"/></a>
				<div id="advanced_search_panel" title="Advanced Search" aria-describedby="dialogDescription" tabindex="-1" style="display: none;">
					<div role="group" aria-describedby="dialogDescription">
						<p id="dialogDescription">Advanced Search</p>
						<?PHP 
						//$this->load->view('/inbox/mailbox_search_panel', array('folder_search_select_menu' => $mailboxes['folder_search_select_menu']), TRUE); 
						$this->load->view('/inbox/mailbox_search_panel');
						?>
					</div>
				</div>
			</div>
        <?php endif ?>
			<?php echo $CI->load->view('message_modal', compact('CI', 'feedback_message', 'feedback_class'), TRUE); ?>
			<?php echo $CI->load->view('disabled_service_notification', array(), TRUE); ?>
		</div>
		<div class="body">
			<div id="mailbox_panel" class="folders-wrapper sidebar-left">
				<a name="mailboxListContent" id="mailboxListContent" class="hidden_context hidden_link">Mailbox List</a>
				<a class="hidden_context hidden_link" href="#mainContent" id="skipMailboxList">Skip Mailbox List</a>
				<div id="folders">
					<button class="minimal minimal-short" type="button" id="compose_btn" onClick="document.location.href='<?PHP echo site_url('inbox/compose') ?>';"> Compose </button>
					<br/>
					<br/>
					<h2 class="hidden_context">Mailbox Folder Menu</h2>
					<?PHP if(!is_array($mailboxes)) {echo $mailboxes;} else {echo $mailboxes['folder_list'];}?> <a class="hidden_context hidden_link" href="#menuContent" id="skipToMenu">Skip to Menu</a>
				</div>
			</div>
			<div class="body-main unit size1of1" id="message_panel">
				<?php if(!empty($modal)) echo $modal ?>
				<?PHP echo form_open_multipart($form_destination, array("id" => "main_form")); ?>
					<div class="menu line">
						<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a>
						<a class="hidden_context hidden_link" name="menuContent" id="skipMenu" href="#mailboxListContent">Skip Menu</a>
						<div class="menu-wrap unit size1of1 line">
						<?php if(!empty($menu_partial)): ?>
							<?php echo $CI->load->view($menu_partial, compact('CI', 'folder_name', 'json_mailbox_list', 'message_count', 'other_members', 'page_start', 'show_workflow', 'total'), TRUE) ?>
						<?php endif ?>
						</div>
					</div>
					<?php if(!empty($user_feedback_message)) echo $user_feedback_message; ?>
					<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
					<h2 class="hidden_context"><?php echo $page_title ?></h2>
					<div id="msg_pane">
						<?php if(!empty($search_message)): ?><h3><?php echo $search_message ?></h3><?php endif ?>
						<?php echo $contents ?>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
	<?PHP echo $CI->load->view('footer', array(), TRUE);  ?>
	<div id="pros_modal"  style="height: 100px; width: 300px; display: none;">
		<p style="text-align: center; ">Processing Request...</p>
		<img src="/images/ajax-loader-large.gif" alt="Processing..." style="display: block; margin-top: 10px; margin-right: auto; margin-left: auto;" />
	</div>
	<script>
	//for nested folder auto expand to the current mailbox
	var ancestor_id_str = '<?php echo $this->session->userdata('ancestor_id_str');?>';
	</script>
</body>
</html>
